#include "univ.h"

#define REMOTEBUFFER 64

static unsigned char RemoteBuffer[REMOTEBUFFER];
static int RemoteIndex;

FlushRemote()
{
	if (RemoteIndex) {
		write(1, RemoteBuffer, RemoteIndex);
		RemoteIndex = 0;
	}
}

void PutRemote(c)
char c;
{
	if (RemoteIndex >= REMOTEBUFFER)
		FlushRemote();
	RemoteBuffer[RemoteIndex++] = c;
}

ToHost(p, l, parent, object)
Protocol p;
long l;
PadObj *parent, *object;
{
	PutRemote(p);
	SendLong(parent->object);
	SendShort(parent->oid);
	SendLong(object->object);
	SendShort(object->oid);
	SendLong(l);
	FlushRemote();
}
	
LineReq(p, lo, hi)
register Pad *p;
long lo, hi;
{
	if( !p || !p->po.object || hi < lo )
		return;
	PutRemote(P_LINEREQ);
	SendLong(p->po.object);
	SendShort(p->po.oid);
	SendLong(p->po.object);
	SendShort(p->po.oid);
	SendLong(lo);
	SendLong(hi);
	FlushRemote();
}
